function [correctedData,deltaFData,deltaF]=fintegratelinear(data,intLimits,fitLimits,FoLimits)

%fintegrateelinear is called by fluorescencewrapper. It subtracts a linear baseline from the raw fluorescence data and returns the
%deltaF/F data.

%Please note: intlimit and fitlimits are not times but are points, so time
%divided by aqu. rate
%example: output=fintegrate(data[from whereever you're getting it], # 3, #
%#)


if length(intLimits)~=2||length(fitLimits)~=2||length(FoLimits)~=2
    error('Limit inputs must contain two values.');
end
close all

%Initialize variables
correctedData=zeros(intLimits(2)-intLimits(1)+1,size(data,2)); %initialize array for corrected data
deltaFData=zeros(intLimits(2)-intLimits(1)+1,size(data,2)); %initialize array for DeltaF values
xdata=(intLimits(1):intLimits(2))'; %the xdata in between the first integration limit and the end integration limit
xfit=(fitLimits(1):fitLimits(2))'; %fit region
xtotal=(min(intLimits(1),fitLimits(1)):max(intLimits(2),fitLimits(2)))';
leakOffsetData=zeros(length(xdata),size(data,2));
leakOffsetTotal=zeros(length(xtotal),size(data,2));
deltaF=zeros(1,size(data,2));
F=zeros(1,size(data,2)); %Fluo level of signal
F01=zeros(1,size(data,2)); %Fluo level of baselined fluorescence
F02=zeros(1,size(data,2)); %Fluo level of background fluorescence (dark fluorescence level
%Variables below could be unhardcoded
F_magnitude_end=intLimits(2)-intLimits(1)-1; %Where to begin taking the deltaF value
F_magnitude_start=intLimits(2)-intLimits(1)-50; %Where to end taking the deltaF value

%Create baseline to subtract from the total data
for n=1:size(data,2)
    %Find linear fit to the fit areas specified by the user and
    %inserted into variable xfit
    leakfit=fit(xfit,data(xfit,n),'poly1');
    fitCoeffs=coeffvalues(leakfit);
    %Use fit coefficients to generate the line that will be deleted from the
    %total
    leakOffsetData(:,n)=xdata*fitCoeffs(1)+fitCoeffs(2);
    leakOffsetTotal(:,n)=xtotal*fitCoeffs(1)+fitCoeffs(2);
    %Delete this line from the data
    correctedData(:,n)=data(xdata,n)-leakOffsetData(:,n);
    %Values below are used to get from fluorescence raw values to deltaF/F
    %values
    %F equals the fluoresecence level of your signal
    F(1,n)=mean(correctedData((F_magnitude_start:F_magnitude_end),n),1);
    %F01 is the fluorescence through the fitLimits
    F01(1,n)=mean(data(fitLimits(1:2),n));
    %F02 is the fluorescence during the dark or background fluorescence
    %times
    F02(1,n)=mean(data(FoLimits(1:2),n));
    %Calculate the deltaF at a point in time
    deltaF(1,n)=100*F(1,n)/(F01(1,n)-F02(1,n));
    %Convert to deltaF data array
    deltaFData(:,n)=100*correctedData(:,n)/(F01(1,n)-F02(1,n));

end

%Plot figure of leak Offset
figure;
plot(xtotal,data(xtotal,:),'b',xtotal,leakOffsetTotal,'r');
%Plot corrected, baseline data
figure;
plot(xdata,correctedData);
%Plot deltaFdata
figure;
plot(xdata,deltaFData);
%Plot deltaF
figure;
plot(deltaF);
output=correctedData;